unit WinForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data,
  Microsoft.DirectX, Microsoft.DirectX.Direct3D;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    constructor Create;
  private
    urzadzenie : Device;
    wierzcholki: VertexBuffer;
  public
    function  InicjujGrafike: Boolean;
    procedure Rysuj;
  private
    function  UtworzBuforWierzch(var urzadzenie: Device): VertexBuffer;
    procedure WypelnijBuforWierzch(var bufor: VertexBuffer);
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(592, 566);
  Self.Name := 'TWinForm';
  Self.Text := 'DirectX.NET Przykad 2';
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

function TWinForm.InicjujGrafike: Boolean;
var
  parametry: PresentParameters;
begin
  try
    parametry:= PresentParameters.Create;
    parametry.Windowed:= true;
    parametry.SwapEffect:= Microsoft.DirectX.Direct3D.SwapEffect.Discard;
    urzadzenie:= Device.Create(0, DeviceType.Hardware, Self.Handle,
      CreateFlags.SoftwareVertexProcessing, [parametry]);
    wierzcholki:= UtworzBuforWierzch(urzadzenie);
    Result:= true;
  except
    on DirectXException do Result:= false;
  end;
end;

procedure TWinForm.Rysuj;
begin
  if urzadzenie=nil then Exit;

  urzadzenie.Clear(ClearFlags.Target, System.Drawing.Color.White, 1, 0);
  urzadzenie.BeginScene;

  urzadzenie.SetStreamSource(0, wierzcholki, 0);
  urzadzenie.DrawPrimitives(PrimitiveType.TriangleList, 0, 1);

  urzadzenie.EndScene;
  urzadzenie.Present;
end;

function TWinForm.UtworzBuforWierzch(var urzadzenie: Device): VertexBuffer;
var bufor: VertexBuffer;
begin
  urzadzenie.VertexFormat:= CustomVertex.TransformedColored.Format;
  bufor:= VertexBuffer.Create(typeof(CustomVertex.TransformedColored),
3, urzadzenie, Usage.WriteOnly, CustomVertex.TransformedColored.Format, Pool.Default);
  WypelnijBuforWierzch(bufor);
  Result:= bufor;
end;

procedure TWinForm.WypelnijBuforWierzch(var bufor: VertexBuffer);
var
   wierzch : Array[0..2] of CustomVertex.TransformedColored;
   strumien: GraphicsStream;
begin
  //Zablokowanie bufora
  strumien:=  bufor.Lock(0, 0, LockFlags.None);
  wierzch[0]:= CustomVertex.TransformedColored.Create(ClientSize.Width/2,  ClientSize.Height/4,  1.0, 1, Color.Red.ToArgb());
  wierzch[1]:= CustomVertex.TransformedColored.Create(ClientSize.Width*3/4,ClientSize.Height*3/4,1.0, 1, Color.Green.ToArgb());
  wierzch[2]:= CustomVertex.TransformedColored.Create(ClientSize.Width/4,  ClientSize.Height*3/4,1.0, 1, Color.Blue.ToArgb());
  strumien.Write(wierzch);
  //Odblokowanie bufora
  bufor.Unlock;
end;

end.
